% Code for: Capital Reallocation and Aggregate Productivity
% R. Cooper & I. Schott
% Code version: September 2022

% Create Figure 5

%% Load results 

F_IRF_data      = readmatrix(sprintf('%s/Figure5_data.csv',PARMS.figfolder));

%% Make graph
xlimset         = [2 20]; % start in the period after the shock
lnwdth          = 2; % line width
fntsize         = 20; % font size
xfntsize        = 15; % font size
idx             = 1; % window count

T               = length(F_IRF_data);

% Agg shock:
subplot(3,2,idx); idx = idx + 1;
plot(1:T,F_IRF_data(:,1)*100,'Linewidth',lnwdth)
title('Adjustment cost $\bar F$','Fontsize',fntsize,'Interpreter','latex')
xlim(xlimset);
ylabel('\% deviation','Fontsize',fntsize,'Interpreter','latex')
grid on
ax = gca;
ax.FontSize = xfntsize; 

% SR
subplot(3,2,idx); idx = idx + 1;
plot(1:T,F_IRF_data(:,2)*100,'Linewidth',lnwdth)
xlim(xlimset);
title('Solow residual','Fontsize',fntsize,'Interpreter','latex')
ylabel('\% deviation','Fontsize',fntsize,'Interpreter','latex')
grid on
ax = gca;
ax.FontSize = xfntsize; 

% MU
subplot(3,2,idx); idx = idx + 1;
plot(1:T,F_IRF_data(:,3)*100,'Linewidth',lnwdth)
hold on
h   = plot(1:T,F_IRF_data(:,4)*100,'--','Linewidth',lnwdth);
ax = ancestor(h, 'axes');
ax.YAxis.Exponent = 0;
ytickformat('%.3f')
xlim(xlimset);
legend({'$\mu_n$','$\mu_a$'},'Fontsize',fntsize,'Interpreter','latex','location','southeast')
ylabel('\% deviation','Fontsize',fntsize,'Interpreter','latex')
title('First moment $\mu$','Fontsize',fntsize,'Interpreter','latex')
grid on
ax = gca;
ax.FontSize = xfntsize; 

% PHI
subplot(3,2,idx); idx = idx + 1;
plot(1:T,F_IRF_data(:,5)*100,'Linewidth',lnwdth)
hold on
h   = plot(1:T,F_IRF_data(:,6)*100,'--','Linewidth',lnwdth);
ax = ancestor(h, 'axes');
ax.YAxis.Exponent = 0;
ytickformat('%.2f')
xlim(xlimset);
ylabel('\% deviation','Fontsize',fntsize,'Interpreter','latex')
title('Second moment $\phi$','Fontsize',fntsize,'Interpreter','latex')
legend({'$\phi_n$','$\phi_a$'},'Fontsize',fntsize,'Interpreter','latex','location','northeast')
grid on
ax = gca;
ax.FontSize = xfntsize; 

% AC
subplot(3,2,idx); idx = idx + 1;
plot(1:T,F_IRF_data(:,7)*100,'Linewidth',lnwdth)
hold on
plot(1:T,F_IRF_data(:,8)*100,'--','Linewidth',lnwdth)
xlim(xlimset);
legend({'$\pi$','AC paid'},'Fontsize',fntsize,'Interpreter','latex','location','northeast')
ylabel('\% deviation','Fontsize',fntsize,'Interpreter','latex')
title('Capital adjustment','Fontsize',fntsize,'Interpreter','latex')
grid on
ax = gca;
ax.FontSize = xfntsize; 

% REALL & DISP
subplot(3,2,idx); idx = idx + 1;
plot(1:T,F_IRF_data(:,9)*100,'Linewidth',lnwdth)
hold on
plot(1:T,F_IRF_data(:,10)*100,'--','Linewidth',lnwdth)
xlim(xlimset);
legend({'$R$','$\sigma$'},'Fontsize',fntsize,'Interpreter','latex','location','northeast')
ylabel('\% deviation','Fontsize',fntsize,'Interpreter','latex')
title('Reallocation \& Dispersion','Fontsize',fntsize,'Interpreter','latex')
grid on
ax = gca;
ax.FontSize = xfntsize; 

set(gcf,'Position',[400 500 900 600])

%% Clean up

clear F_IRF_data ax fntsize h idx lnwdth T x*

